unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, StdCtrls,NozicleComponents,ComCtrls;

type
  TfmMain = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    Label2: TLabel;
    cbTrans: TComboBox;
    meSource: TMemo;
    Label1: TLabel;
    buTranslate: TButton;
    NozicleWebConnection: TNozicleWebConnection;
    NozicleServerScript: TNozicleServerScript;
    meTranslation: TMemo;
    procedure buTranslateClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.DFM}

procedure TfmMain.buTranslateClick(Sender: TObject);
var
  trmode: string;
  sourcedata: string;
  s: string;
  i: integer;
begin
  trmode := '';
  if cbTrans.Text = 'English to Spanish' then trmode := 'en_es';
  if cbTrans.Text = 'English to Chinese' then trmode := 'en_zh';
  if cbTrans.Text = 'English to French' then trmode := 'en_fr';
  if cbTrans.Text = 'English to German' then trmode := 'en_de';
  if cbTrans.Text = 'English to Italian' then trmode := 'en_it';
  if cbTrans.Text = 'English to Japanese' then trmode := 'en_ja';
  if cbTrans.Text = ' English to Korean' then trmode := 'en_ko';
  if cbTrans.Text = ' English to Portuguese' then trmode := 'en_pt';
  if cbTrans.Text = 'Chinese to English' then trmode := 'zh_en';
  if cbTrans.Text = 'French to English' then trmode := 'fr_en';
  if cbTrans.Text = 'French to German' then trmode := 'fr_de';
  if cbTrans.Text = 'German to English' then trmode := 'de_en';
  if cbTrans.Text = 'German to French' then trmode := 'de_fr';
  if cbTrans.Text = 'Italian to English' then trmode := 'it_en';
  if cbTrans.Text = 'Japanese to English' then trmode := 'ja_en';
  if cbTrans.Text = 'Korean to English' then trmode := 'ko_en';
  if cbTrans.Text = 'Portuguese to English' then trmode := 'pt_en';
  if cbTrans.Text = 'Russian to English' then trmode := 'ru_en';
  if cbTrans.Text = 'Spanish to English' then trmode := 'es_en';

  if trmode = '' then exit;

  {remove char#10 and char#13 from the source - may upset the translator if not removed}
  s := meSource.Text;
  sourcedata := '';
  for i := 1 to length(s) do
    if s[i] = Chr(10) then
      sourcedata := sourcedata + ' '
    else
      if s[i] = Chr(13) then
        sourcedata := sourcedata + ' '
      else
        sourcedata := sourcedata + s[i];

  with NozicleServerScript do begin
    Params.Clear;
    Params.Add('translationmode='+trmode);
    Params.Add('sourcedata='+sourcedata);
    meTranslation.Lines.Text := 'Translating...';
    Application.ProcessMessages;
    Execute;
    meTranslation.Lines.Text := ReturnMessage;
  end;

end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
  cbTrans.ItemIndex := 0;
end;

procedure TfmMain.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

end.